#include "CBitmapFont.h"
#include "CBitmapFontManager.h"

CBitmapFont::CBitmapFont(void)
{
	m_pData = NULL;

	SetScaleX(1.0f);
	SetScaleY(1.0f);
}

CBitmapFont::CBitmapFont(CBitmapFontData* pData)
{
	m_pData = pData;

	SetScaleX(1.0f);
	SetScaleY(1.0f);
}

void CBitmapFont::LoadKerning(const char* szFilename)
{
	if(m_pData != NULL)
		m_pData->LoadKerning(szFilename);
}

int CBitmapFont::GetCharWidth(void)		{ return m_pData->GetCharWidth(); }	
int CBitmapFont::GetCharHeight(void)	{ return m_pData->GetCharHeight(); }

void CBitmapFont::DrawString(const char* szText, int nPosX, int nPosY, DWORD color)
{
	m_pData->DrawString(szText, nPosX, nPosY, GetScaleX(), GetScaleY(), color);
}

void CBitmapFont::DrawStringCenter(const char *szText, int nPosX, int nPosY, DWORD color)
{
	if(szText == NULL) return;

	int nNewPosX = 0, nNewPosY = 0;
	unsigned unLength = (unsigned)strlen(szText);
	
	int nWidth = m_pData->GetCharWidth();
	int nHeight = (m_pData->GetCharHeight() >> 1);

	for (unsigned i = 0; i < unLength; i++)
		nNewPosX += (nWidth - m_pData->GetKernWidth(szText[i])) >> 1;
	
	nPosX -= nNewPosX >> 1;

	m_pData->DrawString(szText, nPosX, nPosY - nHeight, GetScaleX(), GetScaleY(), color);
}